IF EXISTS (SELECT * FROM SYS.ALL_OBJECTS WHERE NAME = 'F_MODULO_11' AND TYPE = 'FN')
BEGIN
	DROP FUNCTION F_MODULO_11
END

GO

CREATE FUNCTION F_MODULO_11 (@VALOR VARCHAR(60))
RETURNS CHAR(1)
AS
BEGIN
	DECLARE
		@SOMA INT,
		@CONTADOR INT,
		@PESO INT,
		@DIGITO INT,
		@RETORNO CHAR(1),
		@BASE INT,
		@RESTO BIT

	SET @SOMA = 0
	SET @PESO = 2
	SET @BASE = 9
	SET @RESTO = 0
	SET @CONTADOR = LEN(@VALOR)

	LOOP:
	BEGIN
		SET @SOMA = @SOMA + (CONVERT(INT, SUBSTRING(@VALOR, @CONTADOR, 1)) * @PESO)
		IF (@PESO < @BASE)
			SET @PESO = @PESO + 1
		ELSE
			SET @PESO = 2
		
		SET @CONTADOR = @CONTADOR-1
	END
		IF @CONTADOR >= 1 GOTO LOOP

		IF (@RESTO = 1)
		BEGIN
			SET @RETORNO = (@SOMA % 11)
		END
		ELSE
		BEGIN
			SET @DIGITO = 11 - (@SOMA % 11)
		IF (@DIGITO > 9) SET @DIGITO = 0
			SET @RETORNO = @DIGITO
	END

	RETURN @RETORNO
END
GO

